/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.linker;

import filenet.vw.apps.linker.IVWLinkerTable;
import filenet.vw.apps.linker.VWLinkerDocPropertyDialog;
import filenet.vw.apps.linker.VWLinkerWFPropertyDialog;
import filenet.vw.apps.linker.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDocClass;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMLink;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class VWLinkerTablePanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private int m_firstIndex = 0;
    private int m_lastIndex = 0;
    private ListSelectionModel m_listSelectionModel = null;
    protected VWTable m_linkTable = null;
    protected Frame m_parentFrame = null;
    protected int m_linkType;
    protected IVWIDMDocument m_document = null;
    protected IVWIDMDocClass m_docClass = null;
    protected IVWLinkerTable m_linkTableModel = null;
    private VWLinkerTableMouse m_tableMouse = null;
    protected JButton m_addButton = new JButton(VWResource.Add);
    protected JButton m_editButton = new JButton(VWResource.Edit);
    protected JButton m_deleteButton = new JButton(VWResource.Delete);
    protected JButton m_validateButton = new JButton(VWResource.Validate);

    public void init(Frame parent, IVWIDMDocument document, IVWLinkerTable linkTable, int type) {
        block5: {
            this.m_parentFrame = parent;
            this.m_linkType = type;
            this.m_document = document;
            this.m_linkTableModel = linkTable;
            this.init();
            if (document != null) {
                try {
                    if (document.isWorkflowDefinition()) {
                        this.m_addButton.setEnabled(document.canCreateWorkflowLinkAsWFDefinition());
                        break block5;
                    }
                    this.m_addButton.setEnabled(document.canCreateWorkflowLink());
                }
                catch (Exception e) {
                    this.m_addButton.setEnabled(false);
                }
            } else {
                this.m_addButton.setEnabled(false);
            }
        }
    }

    public void init(Frame parent, IVWIDMDocClass docClass, IVWLinkerTable linkTable, int type) {
        this.m_parentFrame = parent;
        this.m_linkType = 1;
        this.m_docClass = docClass;
        this.m_linkTableModel = linkTable;
        this.init();
    }

    public void init() {
        GridBagConstraints gbConst = null;
        Object[] controls = null;
        try {
            this.m_linkTable = new VWTable(this.m_linkTableModel.getDefaultTableModel());
            this.m_linkTable.setRowSelectionAllowed(true);
            this.m_linkTable.setColumnSelectionAllowed(false);
            this.m_listSelectionModel = this.m_linkTable.getSelectionModel();
            TableColumn aColumn = null;
            if (this.m_linkType == 3) {
                int colWidth;
                aColumn = this.m_linkTable.getColumn(this.m_linkTable.getColumnName(3));
                try {
                    colWidth = Integer.valueOf(VWResource.WFTableVersionColMaxWidth);
                }
                catch (Exception ex) {
                    colWidth = 50;
                }
                aColumn.setMaxWidth(colWidth);
            } else {
                int colWidth;
                aColumn = this.m_linkTable.getColumn(this.m_linkTable.getColumnName(2));
                try {
                    colWidth = Integer.valueOf(VWResource.DocTableVersionColMaxWidth);
                }
                catch (Exception ex) {
                    colWidth = 50;
                }
                aColumn.setMaxWidth(colWidth);
            }
            this.setLayout(new GridBagLayout());
            gbConst = new GridBagConstraints();
            gbConst.gridwidth = 4;
            gbConst.fill = 1;
            gbConst.weightx = 1.0;
            gbConst.weighty = 1.0;
            gbConst.insets = new Insets(4, 4, 4, 4);
            this.add((Component)new JScrollPane(this.m_linkTable), gbConst);
            this.disableLinkButtons();
            controls = new Object[]{this.m_addButton, this.m_editButton, this.m_deleteButton};
            gbConst.gridwidth = 1;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            this.add((Component)this.createButtonPanel(controls), gbConst);
            this.m_tableMouse = new VWLinkerTableMouse();
            this.m_linkTable.addMouseListener(this.m_tableMouse);
            this.m_listSelectionModel.addListSelectionListener(this);
            this.m_addButton.addActionListener(this);
            this.m_editButton.addActionListener(this);
            this.m_deleteButton.addActionListener(this);
            this.m_validateButton.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setDocClass(IVWIDMDocClass docClass) {
        this.m_docClass = docClass;
    }

    protected JPanel createButtonPanel(Object[] buttons) {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst = new GridBagConstraints();
            gbConst.gridwidth = 0;
            gbConst.anchor = 10;
            gbConst.fill = 2;
            gbConst.insets = new Insets(4, 4, 4, 4);
            for (int i = 0; i < buttons.length; ++i) {
                mainPanel.add((Component)((JButton)buttons[i]), gbConst);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object obj = event.getSource();
            if (obj == this.m_addButton) {
                this.performAddLinkAction();
            } else if (obj == this.m_deleteButton) {
                this.performDeleteLinkAction();
            } else if (obj == this.m_editButton) {
                if (this.m_linkType == 3) {
                    this.performEditWorkflowLink();
                } else {
                    this.performEditDocumentLink();
                }
            } else if (obj == this.m_validateButton) {
                this.performValidateLinkAction();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        Object object = event.getSource();
        if (!event.getValueIsAdjusting() && object == this.m_listSelectionModel) {
            this.m_firstIndex = this.m_listSelectionModel.getMinSelectionIndex();
            this.m_lastIndex = this.m_listSelectionModel.getMaxSelectionIndex();
            if (this.m_firstIndex == -1 || this.m_lastIndex == -1) {
                this.disableLinkButtons();
            } else {
                IVWIDMLink aLink = null;
                try {
                    aLink = this.m_linkTableModel.getLink(this.m_firstIndex);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (aLink != null) {
                    this.m_editButton.setEnabled(aLink.canModify());
                    this.m_deleteButton.setEnabled(aLink.canDelete());
                    this.m_validateButton.setEnabled(aLink.canModify());
                } else {
                    this.disableLinkButtons();
                }
            }
        }
    }

    protected void performAddLinkAction() {
        try {
            if (this.m_linkType == 2) {
                this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                VWLinkerDocPropertyDialog linkProperty = new VWLinkerDocPropertyDialog(this.m_parentFrame);
                linkProperty.init(this.m_linkTableModel.getLibrary(), this.m_document);
                this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
                linkProperty.setVisible(true);
                if (linkProperty.getReturnStatus() == 0) {
                    String wfDefDocID = linkProperty.getWfDefDocId();
                    String wfTitle = linkProperty.getWorkflowTitle();
                    String linkName = linkProperty.getLinkName();
                    String subject = linkProperty.getWorkflowSubject();
                    int launchType = linkProperty.getLaunchType();
                    String launchCondition = linkProperty.getLaunchCondition();
                    this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                    IVWIDMLink wfLink = this.m_document.createWorkflowLink(linkName, subject, wfDefDocID, wfTitle, launchType, launchCondition);
                    this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
                    this.m_linkTableModel.addLink(wfLink);
                }
            } else if (this.m_linkType == 1) {
                this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                VWLinkerDocPropertyDialog linkProperty = new VWLinkerDocPropertyDialog(this.m_parentFrame);
                linkProperty.init(this.m_linkTableModel.getLibrary(), this.m_docClass);
                this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
                linkProperty.setVisible(true);
                if (linkProperty.getReturnStatus() == 0) {
                    String wfDefDocID = linkProperty.getWfDefDocId();
                    String wfTitle = linkProperty.getWorkflowTitle();
                    String linkName = linkProperty.getLinkName();
                    String subject = linkProperty.getWorkflowSubject();
                    int launchType = linkProperty.getLaunchType();
                    String launchCondition = linkProperty.getLaunchCondition();
                    this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                    IVWIDMLink wfLink = this.m_docClass.createWorkflowLink(linkName, subject, wfDefDocID, wfTitle, launchType, launchCondition);
                    this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
                    this.m_linkTableModel.addLink(wfLink);
                }
            } else {
                this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                VWLinkerWFPropertyDialog linkProperty = new VWLinkerWFPropertyDialog(this.m_parentFrame);
                linkProperty.init(this.m_linkTableModel.getLibrary(), this.m_document);
                this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
                linkProperty.setVisible(true);
                if (linkProperty.getReturnStatus() == 0) {
                    String wfTitle = this.m_document.getLabel();
                    String wfDefDocID = linkProperty.getWfDefDocId();
                    String linkName = linkProperty.getLinkName();
                    String subject = linkProperty.getWorkflowSubject();
                    int launchType = linkProperty.getLaunchType();
                    String launchCondition = linkProperty.getLaunchCondition();
                    IVWIDMLink wfLink = null;
                    this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                    if (linkProperty.getLinkType() == 1) {
                        IVWIDMDocClass docClass = linkProperty.getDocClass();
                        wfLink = docClass.createWorkflowLink(linkName, subject, wfDefDocID, wfTitle, launchType, launchCondition);
                    } else {
                        IVWIDMDocument document = linkProperty.getDocument();
                        wfLink = document.createWorkflowLink(linkName, subject, wfDefDocID, wfTitle, launchType, launchCondition);
                    }
                    this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
                    this.m_linkTableModel.addLink(wfLink);
                }
            }
        }
        catch (Exception ex) {
            this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
    }

    protected void performDeleteLinkAction() {
        try {
            int[] sel = this.m_linkTable.getSelectedRows();
            boolean bYesToAll = false;
            for (int i = sel.length - 1; i >= 0; --i) {
                IVWIDMLink aLink = this.m_linkTableModel.getLink(sel[i]);
                String linkName = aLink.getName();
                if (!aLink.canDelete()) {
                    JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.CanNotDeleteLink.toString(linkName), null, 1, null);
                    return;
                }
                int ret = 0;
                if (!bYesToAll) {
                    Object[] options1 = new Object[]{VWResource.Yes, VWResource.YesToAll, VWResource.No};
                    ret = JOptionPane.showOptionDialog(this.m_parentFrame, VWResource.ConfirmDeleteLink.toString(linkName), null, -1, 3, null, options1, options1[1]);
                    if (ret == 1) {
                        bYesToAll = true;
                    }
                }
                if (ret != 0 && !bYesToAll) continue;
                this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                aLink.delete();
                this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
                this.m_linkTableModel.removeRow(sel[i]);
            }
            if (this.m_listSelectionModel.getMinSelectionIndex() == -1 || this.m_listSelectionModel.getMaxSelectionIndex() == -1) {
                this.disableLinkButtons();
            }
        }
        catch (Exception ex) {
            this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
    }

    protected void performValidateLinkAction() {
        try {
            int[] sel = this.m_linkTable.getSelectedRows();
            boolean bYesToAll = false;
            for (int i = sel.length - 1; i >= 0; --i) {
                IVWIDMLink aLink = this.m_linkTableModel.getLink(sel[i]);
                String linkName = aLink.getName();
                if (!aLink.canModify()) {
                    JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.CanNotValidateLink.toString(linkName), null, 1, null);
                    return;
                }
                int ret = 0;
                if (!bYesToAll) {
                    Object[] options1 = new Object[]{VWResource.Yes, VWResource.YesToAll, VWResource.No};
                    ret = JOptionPane.showOptionDialog(this.m_parentFrame, VWResource.ConfirmValidateLink.toString(linkName), null, -1, 3, null, options1, options1[1]);
                    if (ret == 1) {
                        bYesToAll = true;
                    }
                }
                if (ret != 0 && !bYesToAll) continue;
                this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                aLink.validate();
                this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (Exception ex) {
            this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
    }

    protected void performEditDocumentLink() {
        try {
            int sel = this.m_linkTable.getSelectedRow();
            if (sel < 0) {
                return;
            }
            IVWIDMLink aLink = this.m_linkTableModel.getLink(sel);
            if (!aLink.canModify()) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.CanNotModifyLink.toString(aLink.getName()), null, 1, null);
                return;
            }
            this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(3));
            VWLinkerDocPropertyDialog linkProperty = new VWLinkerDocPropertyDialog(this.m_parentFrame);
            if (this.m_linkType == 2) {
                linkProperty.init(this.m_linkTableModel.getLibrary(), this.m_document, aLink);
            } else {
                linkProperty.init(this.m_linkTableModel.getLibrary(), this.m_docClass, aLink);
            }
            linkProperty.disableWFEditing();
            this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            linkProperty.setVisible(true);
            if (linkProperty.getReturnStatus() == 0) {
                String launchCondition;
                int launchType;
                String subject;
                String linkName;
                String wfTitle;
                boolean bModified = false;
                String wfDefId = linkProperty.getWfDefDocId();
                if (wfDefId != null && VWStringUtils.compare(wfDefId, aLink.getWflDocID()) != 0) {
                    bModified = true;
                    aLink.setWflDocID(wfDefId);
                    this.m_linkTableModel.setWFVersion(wfDefId, sel);
                }
                if ((wfTitle = linkProperty.getWorkflowTitle()) != null && VWStringUtils.compare(wfTitle, aLink.getWfTitle()) != 0) {
                    bModified = true;
                    aLink.setWfTitle(wfTitle);
                    this.m_linkTableModel.setWfTitle(wfTitle, sel);
                }
                if ((linkName = linkProperty.getLinkName()) != null && VWStringUtils.compare(linkName, aLink.getName()) != 0) {
                    bModified = true;
                    aLink.setName(linkName);
                }
                if ((subject = linkProperty.getWorkflowSubject()) != null && VWStringUtils.compare(subject, aLink.getSubject()) != 0) {
                    bModified = true;
                    aLink.setSubject(subject);
                    this.m_linkTableModel.setSubject(subject, sel);
                }
                if ((launchType = linkProperty.getLaunchType()) != aLink.getEventType()) {
                    bModified = true;
                    aLink.setEventType(launchType);
                    this.m_linkTableModel.setLaunchType(launchType, sel);
                }
                if ((launchCondition = linkProperty.getLaunchCondition()) != null && VWStringUtils.compare(launchCondition, aLink.getExpression()) != 0) {
                    bModified = true;
                    aLink.setExpression(launchCondition);
                }
                if (bModified) {
                    this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                    aLink.save();
                    this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
                    this.m_linkTable.updateUI();
                }
            }
        }
        catch (Exception ex) {
            this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
    }

    protected void performEditWorkflowLink() {
        try {
            int sel = this.m_linkTable.getSelectedRow();
            if (sel < 0) {
                return;
            }
            IVWIDMLink aLink = this.m_linkTableModel.getLink(sel);
            if (!aLink.canModify()) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.CanNotModifyLink.toString(aLink.getName()), null, 1, null);
                return;
            }
            this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(3));
            VWLinkerWFPropertyDialog linkProperty = new VWLinkerWFPropertyDialog(this.m_parentFrame);
            linkProperty.init(this.m_linkTableModel.getLibrary(), this.m_document, aLink);
            linkProperty.disableWFEditing();
            this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            linkProperty.setVisible(true);
            if (linkProperty.getReturnStatus() == 0) {
                String launchCondition;
                int launchType;
                String wfDefId;
                String subject;
                boolean bModified = false;
                String linkName = linkProperty.getLinkName();
                if (linkName != null && VWStringUtils.compare(linkName, aLink.getName()) != 0) {
                    bModified = true;
                    aLink.setName(linkName);
                }
                if ((subject = linkProperty.getWorkflowSubject()) != null && VWStringUtils.compare(subject, aLink.getSubject()) != 0) {
                    bModified = true;
                    aLink.setSubject(subject);
                    this.m_linkTableModel.setSubject(subject, sel);
                }
                if (VWStringUtils.compare(wfDefId = linkProperty.getWfDefDocId(), aLink.getWflDocID()) != 0) {
                    bModified = true;
                    aLink.setWflDocID(wfDefId);
                    this.m_linkTableModel.setWFVersion(wfDefId, sel);
                }
                if ((launchType = linkProperty.getLaunchType()) != aLink.getEventType()) {
                    bModified = true;
                    aLink.setEventType(launchType);
                    this.m_linkTableModel.setLaunchType(launchType, sel);
                }
                if ((launchCondition = linkProperty.getLaunchCondition()) != null && VWStringUtils.compare(launchCondition, aLink.getExpression()) != 0) {
                    bModified = true;
                    aLink.setExpression(launchCondition);
                }
                if (bModified) {
                    this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                    aLink.save();
                    this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
                    this.m_linkTable.updateUI();
                }
            }
        }
        catch (Exception ex) {
            this.m_parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
    }

    protected void disableLinkButtons() {
        this.m_editButton.setEnabled(false);
        this.m_deleteButton.setEnabled(false);
        this.m_validateButton.setEnabled(false);
    }

    private class VWLinkerTableMouse
    extends MouseAdapter {
        private VWLinkerTableMouse() {
        }

        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                if (VWLinkerTablePanel.this.m_linkType == 3) {
                    VWLinkerTablePanel.this.performEditWorkflowLink();
                } else {
                    VWLinkerTablePanel.this.performEditDocumentLink();
                }
            }
        }
    }
}

